/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_NET_INFO_INTERFACE_H
#define _SCE_NET_INFO_INTERFACE_H

#include "np_toolkit_defines.h"

namespace sce {
	namespace Toolkit{
		namespace NP{

		/// @brief
		/// The namespace containing network status functionality.
		///
		/// The namespace containing network status functionality.
		namespace NetInfo {

		/// @brief
		/// The interface for the network status.
		///
		/// This interface allows users to query the network interface, status, collected bandwidth information,
		/// and launch the login dialog for the PlayStation Network.
		class Interface
		{
		public:

			/// @brief 
			/// Gets bandwidth information (asynchronous only).
			///
			/// Measures the network bandwidth between the client and the %NP server. Both the
			/// upstream and downstream bandwidths are obtained. Only conduct bandwidth tests
			/// when necessary as they increase the load on the %NP server.
			///
			/// @note Bandwidth cannot be measured on a network of NAT type 3.
			/// 
			/// @param bandwidthInfo						Output. Receives the upstream and downstream results.
			///
			/// @retval SCE_TOOLKIT_NP_SUCCESS					The operation was successful.							 
			///	@retval	SCE_TOOLKIT_NP_INVALID_POINTER			The operation failed because the pointer passed to <c><i>bandwidthInfo</i></c> was invalid. 
			///	@retval	SCE_TOOLKIT_NP_OPERATION_IN_PROGRESS	The operation failed because the previous operation is in progress.
			static int getBandwidthInfo(sce::Toolkit::NP::Utilities::Future<SceNpUtilBandwidthTestResult> *bandwidthInfo);

			/// @brief 
			/// Gets basic network information.
			///
			/// Gets useful network information such as connection status, IP address and NAT information.
			/// 
			/// @param state								Output. Receives the basic network information
			/// @param async								A flag that indicates whether the function is non-blocking or blocking. 
			///												Defaults to true so the function is non-blocking by default.	
			///
			/// @retval SCE_TOOLKIT_NP_SUCCESS					The operation was successful.							 
			///	@retval	SCE_TOOLKIT_NP_INVALID_POINTER			The operation failed because the pointer passed to <c><i>info</i></c> was invalid. 
			/// @retval SCE_TOOLKIT_NP_NOT_INITIALISED			The operation failed because the %NP %Toolkit library is not initialized.
			/// @retval SCE_TOOLKIT_NP_OFFLINE					The operation failed because the user is not connected to the network.  
			static int getNetInfo(sce::Toolkit::NP::Utilities::Future<NetStateBasic> *state, bool async = true);

			/// @brief 
			/// Gets detailed network information.
			///
			/// Gets verbose network information. This is only really useful for debugging purposes.
			/// 
			/// @param state								Output. Receives detailed network information.
			/// @param async								A flag that indicates whether the function is non-blocking or blocking. 
			///												Defaults to true so the function is non-blocking by default.	
			///
			/// @retval SCE_TOOLKIT_NP_SUCCESS					The operation was successful.							 
			///	@retval	SCE_TOOLKIT_NP_INVALID_POINTER			The operation failed because the pointer passed to <c><i>detailedInfo</i></c> was invalid. 
			/// @retval SCE_TOOLKIT_NP_NOT_INITIALISED			The operation failed because the %NP %Toolkit library is not initialized.
			/// @retval SCE_TOOLKIT_NP_OFFLINE					The operation failed because the user is not connected to the network.  
			static int getNetInfoDetailed(sce::Toolkit::NP::Utilities::Future<NetStateDetailed> *state, bool async = true);

			/// @brief 
			/// Starts the network login dialog.
			///
			/// Starts the network start dialog and prompts the user to sign into the PSN.
			/// 
			/// @param async								A flag that indicates whether the function is non-blocking or blocking. 
			///												Defaults to true so the function is non-blocking by default.
			///
			/// @retval SCE_TOOLKIT_NP_SUCCESS					The operation was successful.							 
			/// @retval SCE_TOOLKIT_NP_NOT_INITIALISED			The operation failed because the %NP %Toolkit library is not initialized.
			///
			/// @note <c>sceCommonDialogUpdate()</c> must be called to ensure the login dialog is displayed.
			static int psnLoginDialogStart(bool async = true);
		};

			}//end NetInfo
		}//end NP
	}//end Toolkit 
}//end sce

#endif
